/** @file   sample.h
 * @brief   Declaration of Sample - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_SAMPLE_H
#define H_ENG2D_SAMPLE_H

#include <string>
#include "eng2d_dll.h"
#include "vec2d.h"

// Forward declarations
struct SAMPLE;

namespace eng2d {


/** @class  Sample
 * @brief   Represents a digital sample.
 * @author  Tomi Lamminsaari
 *
 * Provides simple interface and services for managing the digital audio
 * samples.
 */
class DLLIMPORT Sample
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs new empty sample.
   */
  Sample();
   
	/** Constructs new empty Sample with no data. The ownership of the
   * data at the pointer will not change.
   * @param     pS                Pointer to Allegro-format sample.
   */
	Sample( SAMPLE* pS );
	

	/** Destructor
   */
	virtual ~Sample();


private:

	/** Copy constructor.
   * @param     rO                Reference to another Sample
   */
  Sample( const Sample& rO );

	/** Assignment operator
   * @param     rO                Reference to another Sample
   * @return    Reference to us.
   */
  Sample& operator = ( const Sample& rO );

public:


  ///
  /// Methods
  /// =======

  /** Sets the sample data. The ownership of the data at the pointer
   * will not change.
   *
   * @param     pS                Pointer to Allegro-format sample.
   */
  void setData( SAMPLE* pS );
  



  ///
  /// Getter methods
  /// ==============
  
  /** Returns the pointer to allegro-format sample data.
   * @return    Pointer to sample data. Nullpointer if there is no valid
   *            sampledata.
   */
  SAMPLE* al_SAMPLE() const;

  /** Returns the number of bits the sample has.
   * @return    8 or 16. 0 = no valid sampledata.
   */
  int bits() const;
  
  /** Tells if this is a stereosample.
   * @return    <code>true</code> if stereo
   */
  bool stereo() const;
  
  /** Returns the sample frequency
   * @return    The default frequency. 0 = no valid sampledata
   */
  int freq() const;
  
  /** Returns the length (in samples).
   * @return    Number of samples.
   */
  int len() const;
  
  /** Tells if this sample is valid.
   * @return    <code>true</code> if there is valid sampledata.
   */
  bool isValid() const;

protected:

  ///
  /// Protected methods
  /// =================
  
  
  

  ///
  /// Members
  /// =======

  /** Pointer to the data. */
  SAMPLE*   m_pData;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
